// $Id: CMidiVizEditor.cpp,v 1.13 2007/02/11 02:20:17 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CMidiViz.hpp"
#include "CMidiVizEditor.hpp"
using Exponent::MidiViz::CMidiViz;
using Exponent::MidiViz::CMidiVizEditor;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CMidiVizEditor, CVstWindow);

//	===========================================================================
CMidiVizEditor::CMidiVizEditor(AudioEffect *theEffect, const CRect &windowArea, CWindowAttributes *attributes) 
			  : CVstWindow(theEffect, windowArea, attributes)
			  , m_midiAsNotesButton(NULL)
			  , m_streamOutputButton(NULL)
			  , m_clearOutputButton(NULL)
			  , m_viewMenu(NULL)
			  , m_viewCombo(NULL)
			  , m_channelEdit(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CMidiVizEditor);

#ifdef WIN32
	CFont::CFONT_SYSTEM_FONT->setFont("Arial", 8);
#else
	CFont::CFONT_SYSTEM_FONT->setFont("Arial", 10);
#endif
	

	// NULL all pointers
	for (long i = 0; i < CMIDIVIZ_EDITOR_NUM_CONTROLS; i++)
	{
		NULL_POINTER(m_labels[i]);
	}
	NULL_POINTER(m_midiAsNotesButton);
	NULL_POINTER(m_streamOutputButton);
	NULL_POINTER(m_clearOutputButton);
	NULL_POINTER(m_viewMenu);						
	NULL_POINTER(m_viewCombo);	

	// Now create all the controls
	CSystemString filename = CApplication::getApplicationInstallPath();
#ifdef WIN32
	filename.appendPath("MidiViz\\Resources");
#else
	filename.appendPath("MidiViz.vst/Contents/Resources");
#endif
	this->getControlRoot()->setBackgroundImage(CTGAImage::getNewInstance(filename, "Background.tga"));

	// Create the labels	
	long top = 100;
	for (long i = 0; i < CMIDIVIZ_EDITOR_NUM_CONTROLS; i += CMIDIVIZ_EDITOR_NUM_COLS)
	{
		m_labels[i]     = new CTextLabel(this->getControlRoot(), CControl::CCONTROL_NO_ID_REQUIRED, CRect(20,  top, 96, 20), " ");
		m_labels[i + 1] = new CTextLabel(this->getControlRoot(), CControl::CCONTROL_NO_ID_REQUIRED, CRect(118, top, 46, 20), " ");
		m_labels[i + 2] = new CTextLabel(this->getControlRoot(), CControl::CCONTROL_NO_ID_REQUIRED, CRect(166, top, 46, 20), " ");
		m_labels[i + 3] = new CTextLabel(this->getControlRoot(), CControl::CCONTROL_NO_ID_REQUIRED, CRect(214, top, 46, 20), " ");

		this->getControlRoot()->addControl(m_labels[i]);
		this->getControlRoot()->addControl(m_labels[i + 1]);
		this->getControlRoot()->addControl(m_labels[i + 2]);
		this->getControlRoot()->addControl(m_labels[i + 3]);

		m_labels[i]->referenced();
		m_labels[i + 1]->referenced();
		m_labels[i + 2]->referenced();
		m_labels[i + 3]->referenced();

		m_labels[i]->setColours(CAlphaColour(55, 67, 69, 255), CAlphaColour(55, 67, 69, 255), CAlphaColour(241, 231, 161, 255));
		m_labels[i + 1]->setColours(CAlphaColour(55, 67, 69, 255), CAlphaColour(55, 67, 69, 255), CAlphaColour(241, 231, 161, 255));
		m_labels[i + 2]->setColours(CAlphaColour(55, 67, 69, 255), CAlphaColour(55, 67, 69, 255), CAlphaColour(241, 231, 161, 255));
		m_labels[i + 3]->setColours(CAlphaColour(55, 67, 69, 255), CAlphaColour(55, 67, 69, 255), CAlphaColour(241, 231, 161, 255));

		top += 20;
	}

	CTGAImage *buttonUpImage = CTGAImage::getNewInstance(filename, "Switch_up.tga");
	CTGAImage *buttonDnImage = CTGAImage::getNewInstance(filename, "Switch_down.tga");
	CTGAImage *sliderUpImage = CTGAImage::getNewInstance(filename, "Slider.tga");
	CTGAImage *sliderDnImage = CTGAImage::getNewInstance(filename, "Slider_down.tga");

	// Midi as notes button
	m_midiAsNotesButton = new CLatchingButton(this->getControlRoot(), CControl::CCONTROL_NO_ID_REQUIRED, CRect(127, 43, 22, 33), NULL);
	m_midiAsNotesButton->referenced();
	this->getControlRoot()->addControl(m_midiAsNotesButton);
	m_midiAsNotesButton->setPrimaryImage(sliderUpImage);
	m_midiAsNotesButton->setDownImage(sliderDnImage);

	// Stream output button
	m_streamOutputButton = new CLatchingButton(this->getControlRoot(), 0, CRect(250, 32, 20, 22), this);
	m_streamOutputButton->referenced();
	this->getControlRoot()->addControl(m_streamOutputButton);
	m_streamOutputButton->setPrimaryImage(buttonDnImage);
	m_streamOutputButton->setDownImage(buttonUpImage);

	// Clear output button
	m_clearOutputButton = new CMomentaryButton(this->getControlRoot(), 1, CRect(250, 54, 20, 22), this);
	m_clearOutputButton->referenced();
	this->getControlRoot()->addControl(m_clearOutputButton);
	m_clearOutputButton->setPrimaryImage(buttonDnImage);
	m_clearOutputButton->setDownImage(buttonUpImage);

	m_channelEdit = new CTextEdit(this->getControlRoot(), e_channelEdit, CRect(97, 22, 29, 16), "1", this);
	m_channelEdit->referenced();
	m_channelEdit->setAlignment(CTextEdit::e_center);
	m_channelEdit->setSingleClickEditable(true);
	m_channelEdit->setTextFormat(CGraphics::e_centerCenterAlign);
	m_channelEdit->doDefaultDrawing(false);
	m_channelEdit->setColours(CAlphaColour(48, 59, 61, 255), CAlphaColour(48, 59, 61, 255), CAlphaColour(241, 231, 161, 255));
	this->getControlRoot()->addControl(m_channelEdit);

	// View menu and combo box
	m_viewMenu = new CMenu();
	m_viewMenu->addMenuItem(new CMenuItem(" All events",	 CMidiViz::e_allEvents));
	m_viewMenu->addMenuItem(new CMenuItem(" Notes only",	 CMidiViz::e_notesOnly));
	m_viewMenu->addMenuItem(new CMenuItem(" CC's only",		 CMidiViz::e_ccOnly));
	m_viewMenu->addMenuItem(new CMenuItem(" CC's And Notes", CMidiViz::e_notesAndCCOnly));
	m_viewMenu->addMenuItem(new CMenuItem(" Other only",	 CMidiViz::e_otherOnly));
	m_viewMenu->referenced();
	m_viewCombo = new CComboBox(this->getControlRoot(), e_viewCombo, CRect(20, 58, 88, 14), " All events", m_viewMenu, this);
	m_viewCombo->referenced();
	m_viewCombo->doDefaultDrawing(false);
	this->getControlRoot()->addControl(m_viewCombo);
	
	// Create the attributes to pass to the windows
	CWindowAttributes theAttributes;
	theAttributes.setBackgroundColour(CColour(215, 219, 223));//22, 33, 44));
	theAttributes.setWindowAlphaValue(0.87);

	// Colours of menus
	SMenuColours colours;
	colours.m_selectedColour       = CAlphaColour(174, 178, 182, 255);
	colours.m_seperatorColour      = CAlphaColour(91, 93, 94, 255);
	colours.m_disabledTextColour   = CAlphaColour(47, 83, 116, 255);
	colours.m_textColour		   = CAlphaColour(26, 62, 96, 255);
	colours.m_subMenuPointerColour = colours.m_seperatorColour;
	colours.m_frameColour		   = CAlphaColour(0, 0, 0, 255);

	// Distortion
	m_viewCombo->setMenuWindowAttributes(&theAttributes, false);
	m_viewCombo->setFont(CFont::CFONT_SYSTEM_FONT);
	m_viewCombo->setMenuColours(colours);
	m_viewCombo->setColours(CAlphaColour(55, 67, 69, 255), CAlphaColour(55, 67, 69, 255), CAlphaColour(241, 231, 161, 255));
}

//	===========================================================================
CMidiVizEditor::~CMidiVizEditor()
{
	EXPONENT_CLASS_DESTRUCTION(CMidiVizEditor);
	for (long i = 0; i < CMIDIVIZ_EDITOR_NUM_CONTROLS; i++)
	{
		FORGET_COUNTED_OBJECT(m_labels[i]);
	}
	FORGET_COUNTED_OBJECT(m_midiAsNotesButton);
	FORGET_COUNTED_OBJECT(m_streamOutputButton);
	FORGET_COUNTED_OBJECT(m_clearOutputButton);
	FORGET_COUNTED_OBJECT(m_viewMenu);						
	FORGET_COUNTED_OBJECT(m_viewCombo);	
	FORGET_COUNTED_OBJECT(m_channelEdit);
}

//	===========================================================================
void CMidiVizEditor::handleActionEvent(const CActionEvent &event)
{
	if (event.getControl()->getUniqueId() == e_viewCombo)
	{
		((CMidiViz *)effect)->setVisibility((CMidiViz::EEventVisibility)m_viewCombo->getSelectedIndex());
	}
	else if (event.getControl()->getUniqueId() == e_channelEdit)
	{
		const CString string = m_channelEdit->getString();
		const long index     = atol(string.getString());			// Ranged  1 - 16
		const long midiIndex = atol(string.getString()) - 1;		// Ranged  0 - 15

		if (index <= 0 || index > 16)
		{
			CDialog::notifyUser("The midi channel must be between 1 and 16", "MidiViz channel set Error");
			m_channelEdit->setText("1");
			((CMidiViz*)effect)->setMidiChannel(0);
		}
		else
		{
			((CMidiViz*)effect)->setMidiChannel(midiIndex);
		}
	}
	else
	{
		if (event.getControl() == m_streamOutputButton)
		{
			if (m_streamOutputButton->isOn())
			{
				CSystemString path = CApplication::getApplicationInstallPath();
				#ifdef WIN32
				path.appendPath("MidiViz");
				#endif
				CSystemString filename = "MidiVizLog";
				if (CDialog::openSaveDialog(path, filename, "Choose filename to save MidiViz log to", "Text files (*.txt)", "txt"))
				{
					if (!filename.hasExtension("txt"))
					{
						filename.appendNewExtension("txt", false);
					}
					((CMidiViz *)effect)->openStream(filename);
				}
				else
				{
					// They cancelled...
					m_streamOutputButton->setValue(0.0);
					m_streamOutputButton->update();
				}
			}
			else
			{
				((CMidiViz *)effect)->closeStream();
			}
		}
		else if (event.getControl() == m_clearOutputButton)
		{
			this->blockUpdates(true);
			for (long i = 0; i < CMIDIVIZ_EDITOR_NUM_CONTROLS; i++)
			{
				m_labels[i]->setText(CString::CSTRING_EMPTY_STRING);
			}
			this->blockUpdates(false);
			this->redrawWindow();
		}
	}
}

//	===========================================================================
void CMidiVizEditor::addEvent(const CMidiEvent &event)
{
	this->blockUpdates(true);
	for (long i = 0; i < CMIDIVIZ_EDITOR_NUM_CONTROLS - CMIDIVIZ_EDITOR_NUM_COLS; i += CMIDIVIZ_EDITOR_NUM_COLS)
	{
		m_labels[i]->setText(    m_labels[i + 4]->getText());
		m_labels[i + 1]->setText(m_labels[i + 1 + 4]->getText());
		m_labels[i + 2]->setText(m_labels[i + 2 + 4]->getText());
		m_labels[i + 3]->setText(m_labels[i + 3 + 4]->getText());
	}

	CString format[4];

	if (event.isNoteOff())
	{
		format[0] = "Note off";
		if (m_midiAsNotesButton->isOn())
		{
			CMidi::getMidiNoteString(event.getValue(), format[1]);
		}
		else
		{
			format[1].setStringWithFormat("%03li", event.getValue());
		}
	}
	else if (event.isNoteOn())
	{
		format[0] = "Note on";
		if (m_midiAsNotesButton->isOn())
		{
			CMidi::getMidiNoteString(event.getValue(), format[1]);
		}
		else
		{
			format[1].setStringWithFormat("%03li", event.getValue());
		}
	}
	else if (event.isControlChange())
	{
		format[0] = "Control change";
		if (event.getValue() == 1)
		{
			format[0] = "Mod. Wheel";
		}
		format[1].setStringWithFormat("%03li", event.getValue());
	}
	else if (event.isAllNotesOff())
	{
		format[0] = "All Notes off";
		format[1].setStringWithFormat("%03li", event.getValue());
	}
	else if (event.isPitchBend())
	{
		format[0] = "Pitch bend";
		format[1].setStringWithFormat("%03.2f", event.getPitchBend());
	}
	else
	{
		format[0] = "Other";
		format[1].setStringWithFormat("%03li", event.getValue());
	}

	format[2].setStringWithFormat("%03li", event.getSubValue());
	format[3].setStringWithFormat("%03li", event.getTimeDelta());

	m_labels[CMIDIVIZ_EDITOR_NUM_CONTROLS - 4]->setText(format[0]);
	m_labels[CMIDIVIZ_EDITOR_NUM_CONTROLS - 3]->setText(format[1]);
	m_labels[CMIDIVIZ_EDITOR_NUM_CONTROLS - 2]->setText(format[2]);
	m_labels[CMIDIVIZ_EDITOR_NUM_CONTROLS - 1]->setText(format[3]);
	this->blockUpdates(false);
	this->redrawWindow();
}